var bridge;

document.addEventListener('WebViewJavascriptBridgeReady', function onBridgeReady(event) {
	bridge = event.bridge
	bridge.init(function(message, response) {
		alert('Received message: ' + message)
		if (response) {}
	})
  bridge.registerHandler("jm_exposeJavascriptMethod", jm_exposeJavascriptMethod);
}, false); // WebViewJavascriptBridgeReady

function jm_exposeJavascriptMethod(methodName)
{
  bridge.registerHandler(methodName, window[methodName]);
}

// creates a JS function locally that maps the method on the other side
// of the bridge. eg. if we have a -[NSObject someMethod:] that we want
// to invoke, we can call bridged_someMethod() in JS
function jm_createBridgedFunctionLocally(methodName)
{
  var localMethodName = 'bridged_' + methodName;
  window[localMethodName] = function(data, responseCallback) {
    jm_callBridgedMethod(methodName, data, responseCallback);
  };
}

function jm_callBridgedMethod(methodName, data, responseCallback)
{
	bridge.callHandler(methodName, data, responseCallback);
}
