// #################### Clean Up ######################

function destroyPlayerBridge(data, callback)
{
	destroyVideoPlayer();
  callback(1);
}

function setPlayerQuality(data, callback)
{
  jm_playbackQuality = data;
  handleQualitySetting();
  callback();
}

function pausePlayback(data, callback)
{
  pauseVideo();
  callback();
}

function resumePlayback(data, callback)
{
  playVideo();
  callback();
}

// #################### Configuration ######################

var jm_videoIdentsInPlaylist;
var jm_playbackQuality;
var jm_startingAtVideoIndex;
var jm_playbackShouldLoop;
var jm_autoPlay;

// video durations less than this amount will ignore
// the startingPosition parameter - eg. for things like
// songs that people will usually want to play from the
// start each time
var jm_rememberPositionThresholdSeconds = 30;

function jm_configurePlayer(onComplete)
{
	bridged_playlistVideoIdents(null, function callback(videoIdents) {
		bridged_playbackQuality(null, function callback(playbackQuality) {
			bridged_startingPlaylistIndex(null, function callback(startingVideoIndex) {
				bridged_shouldLoop(null, function callback(shouldLoop) {
					bridged_shouldAutoplay(null, function callback(shouldAutoplay) {
	
						jm_videoIdentsInPlaylist = videoIdents;
						jm_playbackQuality = playbackQuality;
						jm_startingAtVideoIndex = startingVideoIndex;
						jm_playbackShouldLoop = shouldLoop;
						jm_autoPlay = shouldAutoplay;
	
						onComplete();
						
					});
				});
			});
		});
	});	
}

function jm_getStartingPositionForVideoAtIndex(playlistIndex, callback)
{
	var pIndex = (playlistIndex > 0) ? playlistIndex : 0;
	bridged_startingPositionForVideoAtPlaylistIndex(pIndex, function responseCallback(startingPosition) {
		callback(startingPosition)
	});
}

// #################### Notifications ######################

function jm_playerDidStartPlayingVideoAtIndex(playlistIndex, totalDuration)
{
	var pIndex = (playlistIndex > 0) ? playlistIndex : 0;
	bridged_playerDidStartPlayingVideoAtIndex({
                                  'videoIndex': pIndex,
                                  'totalDuration' : totalDuration
                                  });
}

function jm_playerDidPlayToDuration(playlistIndex, playedDuration, totalDuration)
{  
	var pIndex = (playlistIndex > 0) ? playlistIndex : 0;
	bridged_playerDidPlayToDuration({
                                      'videoIndex': pIndex,
                                      'playedDuration': playedDuration,
                                      'totalDuration' : totalDuration
                                      });

}

function jm_playerDidPause()
{
	bridged_playerDidPause();
}

function jm_playerDidFinishPlayingVideoAtIndex(playlistIndex, atDuration)
{
	var pIndex = (playlistIndex > 0) ? playlistIndex : 0;
	bridged_playerDidFinishPlayingVideo({
			'videoIndex': pIndex,
			'position': currentPlaybackPosition
	});
}

function jm_playerDidLoad()
{
	bridged_playerDidLoad();
}

function jm_playerWillFinishPlaylistPlayback()
{
	bridged_playerWillFinishPlaylistPlayback(3);
}

function jm_playerDidFinishPlaylistPlayback()
{
	bridged_playerDidFinishPlaylistPlayback();	
}

function jm_playerDidFail(reason)
{
	bridged_playerDidFailWithReason(reason);
}
