var player;

// 2. This code loads the IFrame Player API code asynchronously.
var tag = document.createElement('script');
tag.src = "http://www.youtube.com/iframe_api";
var firstScriptTag = document.getElementsByTagName('script')[0];
firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);

// 3. This function creates an <iframe> (and YouTube player)
//    after the API code downloads.

function onYouTubeIframeAPIReady() {

	player = new YT.Player('player', {
		height: '300',
		width: '300',
		playerVars: {
			'allowScriptAccess': 'always',
      'playsinline': 1,
			'iv_load_policy' : 3,
			'modestbranding' : 1,
			'showinfo' : 0,
			'rel' : 0,
      'autoplay' : 0
		},
		events: {
			'onReady': onPlayerReady,
			'onStateChange': onPlayerStateChange,
			'onError': onPlayerError
		}
	});
}

function goFullscreen(element) {
	if (element.mozRequestFullScreen) {
		element.mozRequestFullScreen();
	} else if (element.webkitRequestFullScreen) {
		element.webkitRequestFullScreen();
	}
}

// 4. The API will call this function when the video player is ready.

function onPlayerReady(event) {
	var obj = event.target;
	var methods = [];
	for (var m in obj) {
		if (typeof obj[m] == "function") {
			methods.push(m);
		}
	}
	event.target.getIframe()
		.setAttribute('allowfullscreen', 'true')
	event.target.getIframe()
		.setAttribute('webkitAllowFullScreen', 'true')
	goFullscreen(event.target.getIframe());

	jm_configurePlayer(function callback(){
    if (jm_autoPlay)
    {
      event.target.loadPlaylist(jm_videoIdentsInPlaylist, jm_startingAtVideoIndex, 0, jm_playbackQuality);
    }
    else
    {
      event.target.cuePlaylist(jm_videoIdentsInPlaylist, jm_startingAtVideoIndex, 0, jm_playbackQuality);
    }
    event.target.setLoop(jm_playbackShouldLoop);
    jm_playerDidLoad();
	});
}

function onPlayerError(event) {
	jm_playerDidFail(event.data);
}

// 5. The API calls this function when the player's state changes.
//    The function indicates that when playing a video (state=1),
//    the player should play for six seconds and then stop.
var requiresStartingPositionCheck = true;

var currentPlaybackPosition;
var heartbeat = setInterval(notifyPlaybackPosition, 400);

function onPlayerStateChange(event) {
	if (event.data == YT.PlayerState.PLAYING) {
		jm_playerDidStartPlayingVideoAtIndex(player.getPlaylistIndex(), player.getDuration());
		handleExistingPlaybackPosition();
		handleQualitySetting();
	} else if (event.data == YT.PlayerState.PAUSED) {
		jm_playerDidPause();
	} else if (event.data == YT.PlayerState.ENDED) {
		playbackEndTime = new Date().getTime();
		jm_playerDidFinishPlayingVideoAtIndex(player.getPlaylistIndex(), currentPlaybackPosition);
		jm_playerDidFinishPlaylistPlayback();
	} else if (event.data == -1) {
		// switching videos/loading
		jm_playerDidFinishPlayingVideoAtIndex(player.getPlaylistIndex(), currentPlaybackPosition);
		requiresStartingPositionCheck = true;
	} else if (event.data == YT.PlayerState.CUED) {
  }
}

function notifyPlaybackPosition() {
	currentPlaybackPosition = player.getCurrentTime();
	if (player.getPlayerState() == YT.PlayerState.PLAYING)
	{
		jm_playerDidPlayToDuration(player.getPlaylistIndex(), currentPlaybackPosition, player.getDuration());
	}
}

function handleQualitySetting() {
	player.setPlaybackQuality(jm_playbackQuality);
}

function handleExistingPlaybackPosition() {
	jm_getStartingPositionForVideoAtIndex(player.getPlaylistIndex(), function callback(startingPositionSeconds){
		if (player.getDuration() >= jm_rememberPositionThresholdSeconds && startingPositionSeconds > 0 && requiresStartingPositionCheck) {
			player.pauseVideo();
			setTimeout(skipToStartingPosition, 800);
		}
    else
    {
      setTimeout(resumePlaybackWithoutSkipping, 800);
    }
	});
}

function resumePlaybackWithoutSkipping() {
  player.playVideo();
  requiresStartingPositionCheck = false;
}

function skipToStartingPosition() {
	jm_getStartingPositionForVideoAtIndex(player.getPlaylistIndex(), function callback(startingPositionSeconds){
		player.seekTo(startingPositionSeconds, true);
    player.unMute();
		player.playVideo();
	});
  requiresStartingPositionCheck = false;
}

function stopVideo() {
	player.stopVideo();
}

function pauseVideo(data) {
	player.pauseVideo();
}

function playVideo(data) {
	player.playVideo();
}

function destroyVideoPlayer() {
	clearInterval(heartbeat);
  player.stopVideo();
	player.destroy();
}

/// resize to fit

function pageY(elem) {
    return elem.offsetParent ? (elem.offsetTop + pageY(elem.offsetParent)) : elem.offsetTop;
}

function pageX(elem) {
    return elem.offsetParent ? (elem.offsetLeft + pageX(elem.offsetParent)) : elem.offsetLeft;
}


var buffer = 0; //scroll bar buffer

function resizePlayerToFit() {
		
    var height = window.innerHeight || document.body.clientHeight || document.documentElement.clientHeight;
    height -= pageY(document.getElementById('player'))+ buffer ;
    height = (height < 0) ? 0 : height;
    document.getElementById('player').style.height = height + 'px';
		
    var width = window.innerWidth || document.body.clientWidth || document.documentElement.clientWidth;
    width -= pageX(document.getElementById('player'))+ buffer ;
    width = (width < 0) ? 0 : width;
    document.getElementById('player').style.width = width + 'px';
}

window.onresize = resizePlayerToFit;
window.onload = resizePlayerToFit;