#include <string.h> 
#include "ProxyPPC.h"

int HasProxyPrefix(const cc_string* url) {
    const char* proxyPrefix = PROXY_PREFIX;
    int prefixLen = strlen(proxyPrefix);
    int i;
    
    if (url->length < prefixLen) return 0;
    
    for (i = 0; i < prefixLen; i++) {
        if (url->buffer[i] != proxyPrefix[i]) {
            return 0;
        }
    }
    return 1;
}

void RemoveProxyPrefix(cc_string* url) {
    int prefixLen, newLength;
    
    if (!url || url->length == 0) return;
    
    if (HasProxyPrefix(url)) {
        const char* proxyPrefix = PROXY_PREFIX;
        prefixLen = strlen(proxyPrefix);
        newLength = url->length - prefixLen;
        
        if (newLength > 0) {
            memmove(url->buffer, url->buffer + prefixLen, newLength);
        }
        url->buffer[newLength] = '\0';
        url->length = newLength;
    }
}

void ApplyProxyPPC(cc_string* url) {
    int prefixLen, newLength;
    
    if (!url || url->length == 0) return;
    
    if (HasProxyPrefix(url)) return;
    
    {
        const char* proxyPrefix = PROXY_PREFIX;
        prefixLen = strlen(proxyPrefix);
        newLength = url->length + prefixLen;
        
        if (newLength + 1 > url->capacity) {
            return;
        }
        
        memmove(url->buffer + prefixLen, url->buffer, url->length + 1);
        
        memcpy(url->buffer, proxyPrefix, prefixLen);
        
        url->length = newLength;
    }
}